IF NOT OBJECT_ID ('FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_CONTROLE') IS NULL
BEGIN
	--Deletando referencia do lote com o controle PG_DEB_PAGFOR_RETORNO
	ALTER TABLE [dbo].[PG_DEB_PAGFOR_RETORNO] DROP CONSTRAINT [FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_CONTROLE]
END
GO
IF NOT OBJECT_ID ('PK_PG_DEB_PAGFOR_RETORNO') IS NULL
BEGIN
	--Deletando pk da tabela de retorno PG_DEB_PAGFOR_RETORNO
	ALTER TABLE [dbo].[PG_DEB_PAGFOR_RETORNO] DROP CONSTRAINT [PK_PG_DEB_PAGFOR_RETORNO]
END
GO
IF NOT OBJECT_ID ('PK_PG_DEB_PAGFOR_CONTROLE') IS NULL
BEGIN
	--Deletando pk da tabela de controle PG_DEB_PAGFOR_CONTROLE
	ALTER TABLE [dbo].[PG_DEB_PAGFOR_CONTROLE] DROP CONSTRAINT [PK_PG_DEB_PAGFOR_CONTROLE]
END
GO

IF NOT OBJECT_ID ('FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_LOTE') IS NULL
BEGIN
	--Deletando pk da tabela de controle PG_DEB_PAGFOR_RETORNO
	ALTER TABLE [dbo].[PG_DEB_PAGFOR_CONTROLE] DROP CONSTRAINT [FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_LOTE]
END
GO

IF NOT OBJECT_ID ('FK_PG_DEB_PAGFOR_LOTE_PG_DEB_PAGFOR_LOTE') IS NULL
	BEGIN
		--Referencia cruzada
		ALTER TABLE [dbo].[PG_DEB_PAGFOR_LOTE] DROP CONSTRAINT [FK_PG_DEB_PAGFOR_LOTE_PG_DEB_PAGFOR_LOTE]
	END
GO
IF NOT OBJECT_ID ('FK_PG_DEB_PAGFOR_CONTROLE_PG_DEB_PAGFOR_LOTE1') IS NULL
	BEGIN
		ALTER TABLE [dbo].[PG_DEB_PAGFOR_CONTROLE] DROP CONSTRAINT [FK_PG_DEB_PAGFOR_CONTROLE_PG_DEB_PAGFOR_LOTE1]
	END
GO
IF NOT EXISTS(SELECT 1 fROM INFORMATION_SCHEMA.COLUMNS
					WHERE TABLE_NAME='PG_DEB_PAGFOR_RETORNO' AND COLUMN_NAME='CD_CNT')
begin
--Criando o campo de conta no retorno PG_DEB_PAGFOR_RETORNO
ALTER TABLE dbo.PG_DEB_PAGFOR_RETORNO ADD
	CD_CNT int NOT NULL CONSTRAINT DF_PG_DEB_PAGFOR_RETORNO_CD_CNT DEFAULT 0
end
GO
IF NOT EXISTS(SELECT 1 fROM INFORMATION_SCHEMA.COLUMNS
					WHERE TABLE_NAME='PG_DEB_PAGFOR_CONTROLE' AND COLUMN_NAME='CD_CNT')
begin
--Criando o campo de conta no retorno PG_DEB_PAGFOR_CONTROLE
ALTER TABLE dbo.PG_DEB_PAGFOR_CONTROLE ADD
	CD_CNT int NOT NULL CONSTRAINT DF_PG_DEB_PAGFOR_CONTROLE_CD_CNT DEFAULT 0
end
GO
--Deletando sem vinculo
DELETE
	PG_DEB_PAGFOR_CONTROLE
FROM            
	PG_DEB_PAGFOR_CONTROLE LEFT OUTER JOIN PG_DEB_PAGFOR_LOTE ON 
	PG_DEB_PAGFOR_CONTROLE.CD_EMP = PG_DEB_PAGFOR_LOTE.CD_EMP AND 
	PG_DEB_PAGFOR_CONTROLE.CD_BC = PG_DEB_PAGFOR_LOTE.CD_BC AND 
	PG_DEB_PAGFOR_CONTROLE.NR_ARQUIVO = PG_DEB_PAGFOR_LOTE.NR_ARQUIVO
WHERE
	PG_DEB_PAGFOR_LOTE.NR_ARQUIVO IS NULL
GO
--Corrigindo vinculo
UPDATE
	PG_DEB_PAGFOR_CONTROLE
SET         
	PG_DEB_PAGFOR_CONTROLE.CD_CNT=PG_DEB_PAGFOR_LOTE.CD_CNT
FROM            
	PG_DEB_PAGFOR_CONTROLE INNER JOIN PG_DEB_PAGFOR_LOTE ON 
	PG_DEB_PAGFOR_CONTROLE.CD_EMP = PG_DEB_PAGFOR_LOTE.CD_EMP AND 
	PG_DEB_PAGFOR_CONTROLE.CD_BC = PG_DEB_PAGFOR_LOTE.CD_BC AND 
	PG_DEB_PAGFOR_CONTROLE.NR_ARQUIVO = PG_DEB_PAGFOR_LOTE.NR_ARQUIVO
WHERE
	PG_DEB_PAGFOR_CONTROLE.CD_CNT<>PG_DEB_PAGFOR_LOTE.CD_CNT
GO
--Corrigindo vinculo
UPDATE
	PG_DEB_PAGFOR_RETORNO
SET         
	PG_DEB_PAGFOR_RETORNO.CD_CNT=PG_DEB_PAGFOR_LOTE.CD_CNT
FROM            
	PG_DEB_PAGFOR_RETORNO INNER JOIN PG_DEB_PAGFOR_LOTE ON 
	PG_DEB_PAGFOR_RETORNO.CD_EMP = PG_DEB_PAGFOR_LOTE.CD_EMP AND 
	PG_DEB_PAGFOR_RETORNO.CD_BC = PG_DEB_PAGFOR_LOTE.CD_BC AND 
	PG_DEB_PAGFOR_RETORNO.NR_ARQUIVO = PG_DEB_PAGFOR_LOTE.NR_ARQUIVO
WHERE
	PG_DEB_PAGFOR_RETORNO.CD_CNT<>PG_DEB_PAGFOR_LOTE.CD_CNT
GO

ALTER TABLE [dbo].[PG_DEB_PAGFOR_LOTE] DROP CONSTRAINT [PK_PG_DEB_PAGFOR_LOTE]
GO
ALTER TABLE [dbo].[PG_DEB_PAGFOR_LOTE] ADD CONSTRAINT [PK_PG_DEB_PAGFOR_LOTE] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_BC] ASC,
	[NR_ARQUIVO] ASC,
	[CD_CNT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)
GO
/****** Object:  Index [PK_PG_DEB_PAGFOR_CONTROLE]    Script Date: 21/09/2016 11:15:55 ******/
ALTER TABLE [dbo].[PG_DEB_PAGFOR_CONTROLE] ADD  CONSTRAINT [PK_PG_DEB_PAGFOR_CONTROLE] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_BC] ASC,
	[CD_FILIAL] ASC,
	[NR_ARQUIVO] ASC,
	[CD_PG_CRED] ASC,
	[CD_CNT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
ALTER TABLE [dbo].[PG_DEB_PAGFOR_RETORNO] ADD  CONSTRAINT [PK_PG_DEB_PAGFOR_RETORNO] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_BC] ASC,
	[CD_FILIAL] ASC,
	[NR_ARQUIVO] ASC,
	[CD_PG_CRED] ASC,
	[CD_OCORR] ASC,
	[CD_CNT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
ALTER TABLE [dbo].[PG_DEB_PAGFOR_CONTROLE]  WITH NOCHECK ADD  CONSTRAINT [FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_LOTE] FOREIGN KEY([CD_EMP], [CD_BC], [NR_ARQUIVO], [CD_CNT])
REFERENCES [dbo].[PG_DEB_PAGFOR_LOTE] ([CD_EMP], [CD_BC],  [NR_ARQUIVO], [CD_CNT])
GO
ALTER TABLE [dbo].[PG_DEB_PAGFOR_RETORNO]  WITH NOCHECK ADD  CONSTRAINT [FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_CONTROLE] FOREIGN KEY([CD_EMP], [CD_BC],[CD_FILIAL], [NR_ARQUIVO],[CD_PG_CRED],[CD_CNT])
REFERENCES [dbo].[PG_DEB_PAGFOR_CONTROLE] ([CD_EMP], [CD_BC],[CD_FILIAL], [NR_ARQUIVO],[CD_PG_CRED],[CD_CNT])

